@extends('layouts.app')

@section('title', $app_setting['name'] . ' | Instructor Create')

@section('content')
    <!-- ****Body-Section***** -->
    <div class="app-main-outer">
        <div class="app-main-inner">
            <div class="page-title-actions px-3 d-flex">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('instructor.index') }}">Instructor</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Create</li>
                    </ol>
                </nav>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <h3 class="m-0 p-0">
                                {{ __('Create a New Instructor') }}</h3>
                        </div>
                    </div>
                </div>
            </div>

            <form action="{{ route('instructor.store') }}" method="POST" enctype="multipart/form-data">
                @csrf

                <div class="row">
                    <div class="col-md-12 mt-2">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label class="form-label">Name <span class="text-danger fw-bold">*</span> </label>
                                        <input type="text" name="name" value="{{ old('name') }}" maxlength="50"
                                            id="instructorName" onchange="countNameChar()" class="form-control"
                                            placeholder="Enter user name">
                                        <div class="mt-2">
                                            <strong>Characters: <span id="charCountName">0</span>/50</strong>
                                        </div>
                                        @error('name')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Email <span class="text-danger fw-bold">*</span> </label>
                                        <input type="email" name="email" value="{{ old('email') }}"
                                            class="form-control" placeholder="Enter user email">
                                        @error('email')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Phone <span class="text-danger fw-bold">*</span> </label>
                                        <input type="text" name="phone" value="{{ old('phone') }}"
                                            class="form-control" placeholder="Enter user phone">
                                        @error('phone')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 my-3">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="row">
                                            <div class="col-md-12 mb-3">
                                                <label for="titleInput" class="form-label">Instructor Title</label>
                                                <input type="text" id="instructorTitle" name="title"
                                                    value="{{ old('title') }}" maxlength="60" onchange="updateCharCount()"
                                                    class="form-control" id="titleInput"
                                                    placeholder="Enter instructor title">
                                                <div class="mt-2">
                                                    <strong>Characters: <span id="charCount">0</span>/60</strong>
                                                </div>
                                                @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="col-md-12">
                                                <label for="aboutInput" class="form-label">Instructor About</label>
                                                <textarea name="about" rows="14" class="form-control" id="aboutInput" placeholder="Enter about text">{{ old('about') }}</textarea>
                                                @error('about')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="mb-3">
                                                    <img id="courseImagePreview" src="/assets/images/media/teacher.jpg"
                                                        class="w-100"
                                                        style="max-height: 380px; border-radius:1rem; object-fit: cover">
                                                </div>
                                                <h4 class="form-label">Profile Picture (JPG, JPEG, PNG)*</h4>
                                                <label for="formFileImage" class="w-100 border rounded-3">
                                                    <div class="d-flex justify-content-center align-items-center gap-2 p-3"
                                                        style="width: 160px; background-color: #EDEEF1">
                                                        <span>Choose a file</span>
                                                        <img src="/assets/images/media/file-plus.svg">
                                                    </div>
                                                </label>
                                                <input name="profile_picture" class="form-control form-control-lg"
                                                    id="formFileImage" type="file" hidden
                                                    onchange="document.getElementById('courseImagePreview').src = window.URL.createObjectURL(this.files[0])" />
                                                @error('profile_picture')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-md-12 mt-5">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <label class="form-label">Password <span
                                                        class="text-danger fw-bold">*</span>
                                                </label>
                                                <input type="password" name="password" class="form-control"
                                                    placeholder="Enter user password">
                                                @error('password')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    <p class="text-info mt-2 fw-bold">Please follow these rules when creating a
                                                        new
                                                        password:</p>
                                                    <ul class="text-warning">
                                                        <li>Your password must be at least 8 characters long.</li>
                                                        <li>At least one uppercase letter (A-Z).</li>
                                                        <li>At least one lowercase letter (a-z).</li>
                                                        <li>At least one numeric digit (0-9).</li>
                                                        <li>At least one special character (e.g., !@#$%^&*).</li>
                                                    </ul>
                                                @enderror
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label">Confirm Password <span
                                                        class="text-danger fw-bold">*</span></label>
                                                <input type="password" name="password_confirmation" class="form-control"
                                                    placeholder="Enter user password again">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-5">
                        <div class="card">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-md-6 d-flex align-items-center gap-3">
                                        <div class="form-check">
                                            <input id="featuredInput" name="is_featured"
                                                {{ old('is_featured') ? 'checked' : '' }} class="form-check-input"
                                                type="checkbox">
                                            <label for="featuredInput" class="form-check-label">Feature on
                                                Homepage</label>
                                        </div>
                                        <div class="form-check">
                                            <input id="activeInput" name="is_active"
                                                {{ old('is_active') ? 'checked' : '' }} class="form-check-input"
                                                type="checkbox">
                                            <label for="activeInput" class="form-check-label">Verify Account by
                                                Default</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6 d-flex justify-content-end">
                                        <button type="submit"
                                            class="btn btn-primary px-5 py-2">{{ __('Create') }}</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </form>


            <!-- ****End-Body-Section**** -->
        </div>
    </div>
@endsection

@push('scripts')
    {{-- instructor title char count --}}
    <script>
        // Wait for the DOM to fully load before adding the event listener
        document.addEventListener('DOMContentLoaded', function() {
            // Get references to the input field and character count display
            const titleInput = document.getElementById('instructorTitle');
            const charCountDisplay = document.getElementById('charCount');
            // Function to update the character count
            function updateCharCount() {
                charCountDisplay.textContent = titleInput.value.length;
            }
            // Attach the event listener to update count in real time
            titleInput.addEventListener('input', updateCharCount);
        });
    </script>


    {{-- instructor name char count --}}
    <script>
        // Wait for the DOM to fully load before adding the event listener
        document.addEventListener('DOMContentLoaded', function() {
            // Get references to the input field and character count display
            const titleInput = document.getElementById('instructorName');
            const charCountDisplay = document.getElementById('charCountName');
            // Function to update the character count
            function countNameChar() {
                charCountDisplay.textContent = titleInput.value.length;
            }
            // Attach the event listener to update count in real time
            titleInput.addEventListener('input', countNameChar);
        });
    </script>
@endpush
